﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>

<head>
	<title>Platnosc</title>
	
	<script runat="server" >
		
		
		private OdsetkiKarneParams pars = null;
		private RozliczenieSP.InfoDRWorker drWorker = null;
		private OdsetkiKarneCalcInfo odsInfo =null;
		
		
		[Context(Required = true)]
		public OdsetkiKarneParams Params
		{
			get { return pars; }
			set { pars = value; }
		} 

		
		void OnContextLoad(Object sender, EventArgs args)
		{
			drWorker = new RozliczenieSP.InfoDRWorker();
			drWorker.Dokument = (IRozliczalny)dc.Get(typeof(IRozliczalny));

			odsInfo = OdsetkiKarneCalcInfo.CreateInstance(pars); 
			
			InfoTypOdsetek.EditValue = pars.Description;
			InfoTermin.EditValue = drWorker.Dokument is Platnosc ? ((Platnosc)drWorker.Dokument).Termin.ToString() : "(brak)";
		}


		void OnBeforeRow(Object sender, RowEventArgs args)
		{
			if (drWorker.Dokument is Platnosc)
			{
				drWorker.RozliczenieSP = (RozliczenieSP)args.Row;
				if (drWorker.RozliczenieSP.Data > drWorker.Dokument.TerminPlatnosci)
				{
					int zwlokaDni = drWorker.RozliczenieSP.Data - drWorker.Dokument.TerminPlatnosci;
					IdZwloka.EditValue = zwlokaDni;
					IdOdsetki.EditValue = PoliczOdsetki(zwlokaDni);
				}
			}
		}


		private Currency PoliczOdsetki(int zwlokaDni)
		{
			if (zwlokaDni > 0)
			{
				odsInfo.SetPodmiot(drWorker.Dokument.Podmiot);
				return OdsetkiKalkulator.ObliczCalkowiteOdsetki(drWorker.RozliczenieSP, odsInfo);
			}
			
			return new Currency(0.0, drWorker.KwotaRozliczenia.Symbol);
		}
		
	</script>
</head>

<body>
	<form id="Form1" method="post" runat="server">
	<p>
		<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Kasa.IRozliczalny,Soneta.Kasa" OnContextLoad="OnContextLoad" />
		<eb:ReportHeader ID="ReportHeader" runat="server" Title="Raport rozliczeń|</strong>Dokument: <strong>{0}|</strong>Data: <strong>{1}|</strong>Kontrahent: <strong>{2}" DataMember0="NumerDokumentu" DataMember1="DataDokumentu" DataMember2="Podmiot" />
	</p>

	<table id="IdTable1" cellspacing="0" cellpadding="0" width="80%" border="0">
		<tr>
			<td>Kwota:</td>
			<td align="right"><ea:DataLabel runat="server" DataMember="Kwota" ID="DataLabel11" /></td>
		</tr>
		<tr>
			<td>Data rozliczenia:</td>
			<td align="right"><ea:DataLabel runat="server" DataMember="DataRozliczenia" ID="DataLabel17" /></td>
		</tr>
		<tr>
			<td>Pozostaje do rozliczenia:</td>
			<td align="right"><ea:DataLabel runat="server" DataMember="DoRozliczenia" ID="DataLabel18" /></td>
		</tr>
		<tr>
			<td>Termin płatności:</td>
			<td align="right"><ea:DataLabel runat="server" ID="InfoTermin" /></td>
		</tr>
		<tr>
			<td>Typ odsetek:</td>
			<td align="right"><ea:DataLabel runat="server" ID="InfoTypOdsetek" /></td>
		</tr>
	</table>
	<br/>
	
	<ea:Grid runat="server" DataMember="Rozliczenia" RowTypeName="Soneta.Kasa.RozliczenieSP,Soneta.Kasa" ID="IdGrid" OnBeforeRow="OnBeforeRow" >
		<Columns>
			<ea:GridColumn ID="GridColumn1" runat="server" Width="4" Align="Right" DataMember="#" Caption="LP." />
			<ea:GridColumn ID="GridColumn2" runat="server" Width="12" Align="Center" DataMember="Workers.InfoDR.Rozliczenie.DataDokumentu" Caption="Data" />
			<ea:GridColumn ID="GridColumn3" runat="server" Align="Left" DataMember="Workers.InfoDR.Rozliczenie.NumerDokumentu" Caption="Numer" />
			<ea:GridColumn ID="GridColumn4" runat="server" Width="16" Align="Right" DataMember="Workers.InfoDR.KwotaDokumentu" Total="Sum" Caption="Kwota" />
			<ea:GridColumn ID="GridColumn5" runat="server" Width="16" Align="Right" DataMember="Workers.InfoDR.KwotaRozliczenia" Caption="Rozliczenie" HideZero="True" />
			<ea:GridColumn ID="IdZwloka" runat="server" Width="10" Align="Right" Caption="Zwłoka"  />
			<ea:GridColumn ID="IdOdsetki" runat="server" Width="16" Align="Right" Caption="Odsetki" Total="Sum" />
		</Columns>
	</ea:Grid>
	<eb:ReportFooter ID="ReportFooter" runat="server" />

	</form>
</body>
</html>

